package name.matthewgreet.strutscommons.policy;

import name.matthewgreet.strutscommons.annotation.ByteConversion;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;

public class ByteConverter extends AbstractConverterSupport<ByteConversion,Byte> {

    @Override
    public String format(Byte unformattedValue) throws Exception {
        return unformattedValue.toString();
    }

    @Override
    public Class<Byte> getRecipientClass() {
        return Byte.class;
    }

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public String getRecipientFieldName() {
        return getAnnotation().parsedFieldName();
    }

    @Override
    public ConversionResult<Byte> convert(String formValue, Class<? extends Byte> recipientClass) throws Exception {
        byte parsedValue;
        
        try {
            parsedValue = Byte.parseByte(formValue);
            return ConversionResult.makeSuccessResult(parsedValue);
        }
        catch (NumberFormatException e) {
            return ConversionResult.makeFailureResult();
        }
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

}
