package name.matthewgreet.strutscommons.interceptor;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.text.StringEscapeUtils;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.conversion.impl.ConversionData;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;

/**
 * <P>Struts 2 Interceptor for setting conversion errors as overriding properties of the Value Stack, so rejected and 
 * failed form field values are displayed.  This is the same as ConversionErrorInterceptor except it doesn't write error 
 * messages as AnnotationValidationInterceptor is expected to do this.  In Interceptor stacks, it must be placed after 
 * interceptors to write or inject conversion errors, such as AnnotationValidationIntercetpor2 and 
 * FormRetrieveInterceptor, and after StaticParametersInterceptor as that wipes conversion errors.</P>
 * 
 * <P><U>Interceptor parameters:</U></P>
 *
 * <DL>
 *  <DT>disabled</DT>
 *  <DD>If true, this interceptor is skipped.</DD>
 * </DL>
 *
 * <P><U>Extending the interceptor:</U></P>
 *
 * <P>This can't be usefully extended.</P>
 *
 * <P> <u>Example code:</u></P>
 * <PRE>
 * &lt;action name="someAction" class="com.examples.SomeAction"&gt;
 *     &lt;interceptor-ref name="staticParams"/&gt;
 *     &lt;interceptor-ref name="rejectedFormValues"/&gt;
 *     &lt;result name="success"&gt;good_result.ftl&lt;/result&gt;
 * &lt;/action&gt;
 * <!-- END SNIPPET: example -->
 * </PRE>
 */
@SuppressWarnings("deprecation")
public class RejectedFormValuesInterceptor extends MethodFilterInterceptor {
	private static final long serialVersionUID = 2689404505465349761L;
    
    private boolean disabled;
    
    //private Logger LOG = LogManager.getLogger(ConversionErrorPusherInterceptor.class);
    

    @Override
    protected String doIntercept(ActionInvocation invocation) throws Exception {
		Map<String,ConversionData> conversionErrors;
		Map<Object,Object> propertyOverrides;
		String value;
		
        if (!disabled) {
			conversionErrors = invocation.getInvocationContext().getConversionErrors();
			if (conversionErrors != null) {
				propertyOverrides = new HashMap<>();
				for (Entry<String,ConversionData> entry: conversionErrors.entrySet()) {
					value = "\"" + StringEscapeUtils.escapeJava(String.valueOf(entry.getValue().getValue())) + "\"";
					propertyOverrides.put(entry.getKey(), value);
				}
	            invocation.getStack().setExprOverrides(propertyOverrides);
			}
        }
        
        return invocation.invoke();
    }

	public boolean getDisabled() {
		return disabled;
	}
	public void setDisabled(boolean disabled) {
		this.disabled = disabled;
	}

}
