package name.matthewgreet.strutscommons.interceptor;


import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.ValidationAware;

import name.matthewgreet.strutscommons.interceptor.MessageStoreInterceptor.StoredMessages;

import com.opensymphony.xwork2.interceptor.AbstractInterceptor;


/**
 * <P>If the Struts action implements {@link ValidationAware}, removes errors and messages stored in the session by 
 * {@link MessageStoreInterceptor} and injects it into the action.  It is usually part of the aflViewStack interceptor stack.</P>
 * 
 * 
 * <H2>Interceptor parameters</H2>
 * <DL>
 * <DT>disabled</DT><DD>If true, all processing is disabled.  This is useful for standalone popup windows, especially 
 *                      self-refreshing ones, that never display messages.  Defaults to false.</DD>
 * </DL>
 * 
 * <H2>Extending the interceptor</H2>
 * <P>This interceptor cannot be usefully extended.</P>
 * 
 * <H2>Example code</H2>
 * <PRE>
 * &#064;InterceptorRefs({
 *   &#064;InterceptorRef(value="messageRetrieve"),
 *   &#064;InterceptorRef(value="basicStack")
 *})
 * </PRE>
 */
@SuppressWarnings("deprecation")
public class MessageRetrieveInterceptor extends AbstractInterceptor {
    private static final long serialVersionUID = -6513506646328167140L;

    private Logger LOG = LogManager.getLogger(MessageRetrieveInterceptor.class);
    
    
    private boolean disabled;
    
    
    public MessageRetrieveInterceptor() {
        // Empty
    }

    
    
    public boolean getDisabled() {
        return disabled;
    }
    public void setDisabled(boolean value) {
        disabled = value;
    }
    
    
    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        StoredMessages storedMessages;
        ValidationAware validationAware;
        Object rawObject;
        
        if (!disabled && invocation.getAction() instanceof ValidationAware) {
            rawObject = ActionContext.getContext().getSession().get(MessageStoreInterceptor.SESSION_STORED_MESSAGES);
            if (rawObject != null) {
                if (rawObject instanceof StoredMessages) {
                    storedMessages = (StoredMessages)rawObject;
                    validationAware = (ValidationAware)invocation.getAction();
                    validationAware.setActionErrors(storedMessages.getActionErrors());
                    validationAware.setActionMessages(storedMessages.getActionMessages());
                    validationAware.setFieldErrors(storedMessages.getFieldErrors());
                    ActionContext.getContext().getSession().remove(MessageStoreInterceptor.SESSION_STORED_MESSAGES);
                } else {
                    LOG.warn("Session attribute are not stored messages  session attribute=" + MessageStoreInterceptor.SESSION_STORED_MESSAGES +
                        "  value=" + rawObject);
                }
            }
        }
        return invocation.invoke();
    }

}
