package name.matthewgreet.strutscommons.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import name.matthewgreet.strutscommons.util.DefaultDisplayFormatter;

/**
 * <P>Marks a string field of a view helper not to receive a formatted value using {@link DefaultDisplayFormatter#updateDisplay}.</P>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface DisableFormatting {
    // Empty
}
