package name.matthewgreet.strutscommons.action;

import com.opensymphony.xwork2.ModelDriven;

import name.matthewgreet.strutscommons.form.Form;

/**
 * Interface indicating Struts 2 action accepts form data into a form object and describes how the form should be 
 * handled in workflow.
 *
 * @param <T> Class that accepts form data.
 */
@SuppressWarnings("deprecation")
public interface FormDriven<T extends Form> extends ModelDriven<T> {
    /**
     * Returns whether the user's request was rejected, such as form data itself is invalid, an update rejected by the 
     * back-end or zero query results with zero results not allowed.  This is usually defined as the presence of any
     * error messages.
     */
    public boolean formValidationFailed();
}
