package name.matthewgreet.example11.util;

import java.util.List;

import javax.servlet.http.HttpSession;

import name.matthewgreet.example11.action.ViewPrimeMinisterListAction;
import name.matthewgreet.example11.dto.PrimeMinisterDTO;
import name.matthewgreet.example11.model.PrimeMinisterTable;
import name.matthewgreet.strutscommons.util.AbstractCompositeCache;
import name.matthewgreet.strutscommons.util.ListCache.ListCacheConfig;
import name.matthewgreet.strutscommons.util.ListCache.PaginationMode;
import name.matthewgreet.strutscommons.util.ListFinder;
import name.matthewgreet.strutscommons.util.NA;
import name.matthewgreet.strutscommons.util.SingleItemFinder;


/**
 * 
 * 
 * <STYLE>TABLE {border-collapse: collapse;} TD,TH {border: 1px solid black; text-align: left;}</STYLE>
 * <TABLE>
 *   <TR>
 *     <TH>Slave list no</TH>
 *     <TH>Name</TH>
 *     <TH>Description</TH>
 *     <TH>Viewer action</TH>
 *     <TH>Base record</TH>
 *     <TH>Other base record data</TH>
 *     <TH>Page extension data</TH>
 *     <TH>Detail data</TH>
 *     <TH>Pagination mode</TH>
 *     <TH>List/id/size finder</TH>
 *     <TH>Page finder/ page extension assembler</TH>
 *     <TH>Single item finder</TH>
 *   </TR>
 *   <TR>
 *     <TD>Master</TD>
 *     <TD>UK Prime Ministers</TD>
 *     <TD>Selected UK Prime Ministers</TD>
 *     <TD><CODE>{@link ViewPrimeMinisterListAction}</CODE></TD>
 *     <TD><CODE>{@link PrimeMinisterDTO}</CODE></TD>
 *     <TD>&nbsp;</TD>
 *     <TD>&nbsp;</TD>
 *     <TD>&nbsp;</TD>
 *     <TD ALIGN="CENTER">Full List</TD>
 *     <TD ALIGN="CENTER">{@link PrimeMinisterListFinder}</TD>
 *     <TD ALIGN="CENTER">&nbsp;</TD>
 *     <TD ALIGN="CENTER">{@link PrimeMinisterItemFinder}</TD>
 *   </TR>
 * </TABLE>
 */
public class PrimeMinisterCompositeCache extends AbstractCompositeCache<Integer,PrimeMinisterDTO> {
    public static class PrimeMinisterItemFinder implements SingleItemFinder<Integer,PrimeMinisterDTO> {
		private static final long serialVersionUID = -8352500134074838922L;

		@Override
		public PrimeMinisterDTO getItem(Integer key) throws Exception {
			return PrimeMinisterTable.getInstance().findById(key);
		}
		
	}
	
    public static class PrimeMinisterListFinder implements ListFinder<NA,PrimeMinisterDTO> {
		private static final long serialVersionUID = -5600030757254430879L;

		@Override
		public List<PrimeMinisterDTO> getList(NA selectedMaster) throws Exception {
			return PrimeMinisterTable.getInstance().findAll();
		}
		
	}
	
	private static final long serialVersionUID = -6454993304545014831L;
	
	private static final String ATTR_NAME_CACHE	= PrimeMinisterCompositeCache.class + "_CACHE";
	
	public synchronized static PrimeMinisterCompositeCache getInstance(HttpSession session) {
		PrimeMinisterCompositeCache instance;
		
		instance = (PrimeMinisterCompositeCache)session.getAttribute(ATTR_NAME_CACHE);
		if (instance == null) {
			instance = new PrimeMinisterCompositeCache();
			session.setAttribute(ATTR_NAME_CACHE, instance);
		}
		return instance;
	}
	
	
	public PrimeMinisterCompositeCache() {
		super();
	}
	
	public PrimeMinisterCompositeCache(PrimeMinisterCompositeCache other) throws Exception {
		super(other);
	}

	@Override
	protected ListCacheConfig<NA,Integer,PrimeMinisterDTO> getMasterListCacheConfig() {
		ListCacheConfig<NA,Integer,PrimeMinisterDTO> result;
		
		result = new ListCacheConfig<NA,Integer,PrimeMinisterDTO>();
		result.setHasDetails(false);
		result.setItemDeepCopier(item -> new PrimeMinisterDTO(item));
		result.setItemFinder(new PrimeMinisterItemFinder());
		result.setItemSorter(null);
		result.setKeyExtractor(g -> g.getId());
		result.setListFinder(new PrimeMinisterListFinder());
		result.setName("UK Prime Ministers");
		result.setPaginationMode(PaginationMode.FULL_LIST);
		return result;
	}

}
