package name.matthewgreet.example11.policy;

import name.matthewgreet.example11.annotation.ShortRange;
import name.matthewgreet.strutscommons.annotation.Required.MessageType;
import name.matthewgreet.strutscommons.policy.AbstractPostConversionValidatorSupport;
import name.matthewgreet.strutscommons.policy.ValidationResult;

public class ShortRangeValidator extends AbstractPostConversionValidatorSupport<ShortRange,Short> {

    @Override
    public MessageType getMessageType() {
        return getAnnotation().messageType();
    }

    @Override
    public String getMessage() {
        return getAnnotation().message();
    }

    @Override
    public String getMessageKey() {
        return getAnnotation().messageKey();
    }

    @Override
    public Class<Short> getRecipientClass() {
        return Short.class;
    }

    @Override
    public boolean getShortCircuit() {
        return getAnnotation().shortCircuit();
    }

	@Override
	public boolean getProcessNoValue() {
        return false;
	}

    @Override
    public ValidationResult validate(Short fieldValue) throws Exception {
        short value;
        
        value = fieldValue;
        if (value >= getAnnotation().min() && value <= getAnnotation().max()) {
            return ValidationResult.makeSuccessResult();
        } else {
            return ValidationResult.makeFailureResult();
        }
    }

}
