package name.matthewgreet.example11.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import name.matthewgreet.example11.dto.DateRange;
import name.matthewgreet.example11.dto.PrimeMinisterDTO;
import name.matthewgreet.example11.dto.PrimeMinisterDTO.Party;

public class PrimeMinisterTable {
	private static PrimeMinisterTable instance;
	
	
	public synchronized static PrimeMinisterTable getInstance() {
		if (instance == null) {
			instance = new PrimeMinisterTable();
		}
		return instance;
	}
	
	
	private Map<Integer,PrimeMinisterDTO> table; 
	
	private PrimeMinisterTable() {
		PrimeMinisterDTO primeMinister;
		
		table = new HashMap<>();
		
		primeMinister = new PrimeMinisterDTO();
		primeMinister.setId(1);
		primeMinister.setName("Kier Starmer");
		primeMinister.setDateOfBirth(new GregorianCalendar(1962, Calendar.SEPTEMBER, 2).getTime());
		primeMinister.setWikipediaEntry("https://en.wikipedia.org/wiki/Keir_Starmer");
		primeMinister.getTermsOfOffice().add(new DateRange(new GregorianCalendar(2024, Calendar.JULY, 5).getTime(), null));
		primeMinister.setParty(Party.LABOUR);
		primeMinister.setMaxSeatsWon(411);
		primeMinister.setConstituency("Holborn and St Pancras");
		primeMinister.setBestConstituencyMajority(11572);
		primeMinister.setBestConstituencyYear((short)2024);
		table.put(primeMinister.getId(), primeMinister);
		
		primeMinister = new PrimeMinisterDTO();
		primeMinister.setId(2);
		primeMinister.setName("Rishi Sunak");
		primeMinister.setDateOfBirth(new GregorianCalendar(1980, Calendar.MARCH, 12).getTime());
		primeMinister.setWikipediaEntry("https://en.wikipedia.org/wiki/Rishi_Sunak");
		primeMinister.getTermsOfOffice().add(new DateRange(new GregorianCalendar(2022, Calendar.OCTOBER, 25).getTime(), new GregorianCalendar(2024, Calendar.JULY, 5).getTime()));
		primeMinister.setParty(Party.CONSERVATIVE);
		primeMinister.setMaxSeatsWon(null);
		primeMinister.setConstituency("Richmond (Yorks)");
		primeMinister.setBestConstituencyMajority(19550);
		primeMinister.setBestConstituencyYear((short)2019);
		table.put(primeMinister.getId(), primeMinister);
		
		primeMinister = new PrimeMinisterDTO();
		primeMinister.setId(3);
		primeMinister.setName("Liz Truss");
		primeMinister.setDateOfBirth(new GregorianCalendar(1975, Calendar.JULY, 26).getTime());
		primeMinister.setWikipediaEntry("https://en.wikipedia.org/wiki/Liz_Truss");
		primeMinister.getTermsOfOffice().add(new DateRange(new GregorianCalendar(2022, Calendar.SEPTEMBER, 6).getTime(), new GregorianCalendar(2022, Calendar.OCTOBER, 25).getTime()));
		primeMinister.setParty(Party.CONSERVATIVE);
		primeMinister.setMaxSeatsWon(null);
		primeMinister.setConstituency("South West Norfolk");
		primeMinister.setBestConstituencyMajority(26170);
		primeMinister.setBestConstituencyYear((short)2019);
		table.put(primeMinister.getId(), primeMinister);
		
		primeMinister = new PrimeMinisterDTO();
		primeMinister.setId(4);
		primeMinister.setName("Boris Johnson");
		primeMinister.setDateOfBirth(new GregorianCalendar(1964, Calendar.JUNE, 19).getTime());
		primeMinister.setWikipediaEntry("https://en.wikipedia.org/wiki/Boris_Johnson");
		primeMinister.getTermsOfOffice().add(new DateRange(new GregorianCalendar(2019, Calendar.JULY, 24).getTime(), new GregorianCalendar(2022, Calendar.SEPTEMBER, 6).getTime()));
		primeMinister.setParty(Party.CONSERVATIVE);
		primeMinister.setMaxSeatsWon(365);
		primeMinister.setConstituency("Uxbridge and South Ruislip");
		primeMinister.setBestConstituencyMajority(7210);
		primeMinister.setBestConstituencyYear((short)2019);
		table.put(primeMinister.getId(), primeMinister);
		
		primeMinister = new PrimeMinisterDTO();
		primeMinister.setId(5);
		primeMinister.setName("Theresa May");
		primeMinister.setDateOfBirth(new GregorianCalendar(1956, Calendar.OCTOBER, 1).getTime());
		primeMinister.setWikipediaEntry("https://en.wikipedia.org/wiki/Theresa_May");
		primeMinister.getTermsOfOffice().add(new DateRange(new GregorianCalendar(2016, Calendar.JULY, 13).getTime(), new GregorianCalendar(2019, Calendar.JULY, 24).getTime()));
		primeMinister.setParty(Party.CONSERVATIVE);
		primeMinister.setMaxSeatsWon(317);
		primeMinister.setConstituency("Maidenhead");
		primeMinister.setBestConstituencyMajority(29059);
		primeMinister.setBestConstituencyYear((short)2015);
		table.put(primeMinister.getId(), primeMinister);
		
		primeMinister = new PrimeMinisterDTO();
		primeMinister.setId(6);
		primeMinister.setName("David Cameron");
		primeMinister.setDateOfBirth(new GregorianCalendar(1966, Calendar.OCTOBER, 9).getTime());
		primeMinister.setWikipediaEntry("https://en.wikipedia.org/wiki/David_Cameron");
		primeMinister.getTermsOfOffice().add(new DateRange(new GregorianCalendar(2010, Calendar.MAY, 11).getTime(), new GregorianCalendar(2016, Calendar.JULY, 13).getTime()));
		primeMinister.setParty(Party.CONSERVATIVE);
		primeMinister.setMaxSeatsWon(330);
		primeMinister.setConstituency("Witney");
		primeMinister.setBestConstituencyMajority(25155);
		primeMinister.setBestConstituencyYear((short)2015);
		table.put(primeMinister.getId(), primeMinister);
		
		primeMinister = new PrimeMinisterDTO();
		primeMinister.setId(7);
		primeMinister.setName("Gordon Brown");
		primeMinister.setDateOfBirth(new GregorianCalendar(1951, Calendar.FEBRUARY, 20).getTime());
		primeMinister.setWikipediaEntry("https://en.wikipedia.org/wiki/Gordon_Brown");
		primeMinister.getTermsOfOffice().add(new DateRange(new GregorianCalendar(2007, Calendar.JUNE, 27).getTime(), new GregorianCalendar(2010, Calendar.MAY, 11).getTime()));
		primeMinister.setParty(Party.LABOUR);
		primeMinister.setMaxSeatsWon(null);
		primeMinister.setConstituency("Kirkcaldy and Cowdenbeath");
		primeMinister.setBestConstituencyMajority(23009);
		primeMinister.setBestConstituencyYear((short)2010);
		table.put(primeMinister.getId(), primeMinister);
		
		primeMinister = new PrimeMinisterDTO();
		primeMinister.setId(8);
		primeMinister.setName("Tony Blair");
		primeMinister.setDateOfBirth(new GregorianCalendar(1953, Calendar.MAY, 6).getTime());
		primeMinister.setWikipediaEntry("https://en.wikipedia.org/wiki/Tony_Blair");
		primeMinister.getTermsOfOffice().add(new DateRange(new GregorianCalendar(1997, Calendar.MAY, 2).getTime(), new GregorianCalendar(2007, Calendar.JUNE, 27).getTime()));
		primeMinister.setParty(Party.LABOUR);
		primeMinister.setMaxSeatsWon(418);
		primeMinister.setConstituency("Sedgefield");
		primeMinister.setBestConstituencyMajority(25143);
		primeMinister.setBestConstituencyYear((short)1997);
		table.put(primeMinister.getId(), primeMinister);
		
		primeMinister = new PrimeMinisterDTO();
		primeMinister.setId(9);
		primeMinister.setName("John Major");
		primeMinister.setDateOfBirth(new GregorianCalendar(1943, Calendar.MARCH, 29).getTime());
		primeMinister.setWikipediaEntry("https://en.wikipedia.org/wiki/John_Major");
		primeMinister.getTermsOfOffice().add(new DateRange(new GregorianCalendar(1990, Calendar.NOVEMBER, 28).getTime(), new GregorianCalendar(1997, Calendar.MAY, 2).getTime()));
		primeMinister.setParty(Party.CONSERVATIVE);
		primeMinister.setMaxSeatsWon(336);
		primeMinister.setConstituency("Huntingdon");
		primeMinister.setBestConstituencyMajority(36230);
		primeMinister.setBestConstituencyYear((short)1992);
		table.put(primeMinister.getId(), primeMinister);
		
		primeMinister = new PrimeMinisterDTO();
		primeMinister.setId(10);
		primeMinister.setName("Margaret Thatcher");
		primeMinister.setDateOfBirth(new GregorianCalendar(1925, Calendar.OCTOBER, 13).getTime());
		primeMinister.setWikipediaEntry("https://en.wikipedia.org/wiki/Margaret_Thatcher");
		primeMinister.getTermsOfOffice().add(new DateRange(new GregorianCalendar(1979, Calendar.MAY, 4).getTime(), new GregorianCalendar(1990, Calendar.NOVEMBER, 28).getTime()));
		primeMinister.setParty(Party.CONSERVATIVE);
		primeMinister.setMaxSeatsWon(397);
		primeMinister.setConstituency("Finchley");
		primeMinister.setBestConstituencyMajority(9314);
		primeMinister.setBestConstituencyYear((short)1983);
		table.put(primeMinister.getId(), primeMinister);
		
		primeMinister = new PrimeMinisterDTO();
		primeMinister.setId(11);
		primeMinister.setName("James Callaghan");
		primeMinister.setDateOfBirth(new GregorianCalendar(1912, Calendar.MARCH, 27).getTime());
		primeMinister.setWikipediaEntry("https://en.wikipedia.org/wiki/James_Callaghan");
		primeMinister.getTermsOfOffice().add(new DateRange(new GregorianCalendar(1976, Calendar.APRIL, 5).getTime(), new GregorianCalendar(1979, Calendar.MAY, 4).getTime()));
		primeMinister.setParty(Party.LABOUR);
		primeMinister.setMaxSeatsWon(null);
		primeMinister.setConstituency("Cardiff South East");
		primeMinister.setBestConstituencyMajority(10718);
		primeMinister.setBestConstituencyYear((short)1974);
		table.put(primeMinister.getId(), primeMinister);
		
		primeMinister = new PrimeMinisterDTO();
		primeMinister.setId(12);
		primeMinister.setName("Harold Wilson");
		primeMinister.setDateOfBirth(new GregorianCalendar(1916, Calendar.MARCH, 11).getTime());
		primeMinister.setWikipediaEntry("https://en.wikipedia.org/wiki/Harold_Wilson");
		primeMinister.getTermsOfOffice().add(new DateRange(new GregorianCalendar(1964, Calendar.OCTOBER, 16).getTime(), new GregorianCalendar(1970, Calendar.JUNE, 19).getTime()));
		primeMinister.getTermsOfOffice().add(new DateRange(new GregorianCalendar(1974, Calendar.MARCH, 4).getTime(), new GregorianCalendar(1976, Calendar.APRIL, 5).getTime()));
		primeMinister.setParty(Party.LABOUR);
		primeMinister.setMaxSeatsWon(364);
		primeMinister.setConstituency("Huyton");
		primeMinister.setBestConstituencyMajority(9455);
		primeMinister.setBestConstituencyYear((short)1966);
		table.put(primeMinister.getId(), primeMinister);
		
	}
	
	
	public List<PrimeMinisterDTO> findAll() {
		return new ArrayList<>(table.values());
	}
	
	public PrimeMinisterDTO findById(int id) {
		return table.get(id);
	}
}


