package name.matthewgreet.example11.form;

import java.util.Date;
import java.util.List;

import org.apache.commons.beanutils.PropertyUtils;

import name.matthewgreet.example11.annotation.AgeRange;
import name.matthewgreet.example11.annotation.DateRangeListConversion;
import name.matthewgreet.example11.annotation.IntegerInnerOuterRange;
import name.matthewgreet.example11.annotation.IntegerLocaleConversion;
import name.matthewgreet.example11.annotation.NoDateRangeOverlap;
import name.matthewgreet.example11.annotation.ShortRange;
import name.matthewgreet.example11.annotation.StartsWith;
import name.matthewgreet.example11.annotation.ToCapitalised;
import name.matthewgreet.example11.dto.DateRange;
import name.matthewgreet.example11.dto.PrimeMinisterDTO;
import name.matthewgreet.example11.dto.PrimeMinisterDTO.Party;
import name.matthewgreet.strutscommons.annotation.DateConversion;
import name.matthewgreet.strutscommons.annotation.IntegerRange;
import name.matthewgreet.strutscommons.annotation.MaxLength;
import name.matthewgreet.strutscommons.annotation.Required;
import name.matthewgreet.strutscommons.annotation.ShortConversion;
import name.matthewgreet.strutscommons.annotation.Trim;
import name.matthewgreet.strutscommons.form.AbstractFormattableForm;

public class PrimeMinisterForm extends AbstractFormattableForm {
	private static final long serialVersionUID = -6937072630784482008L;
	
	@Trim
	@ToCapitalised
	@Required(messageKey = "validation.name.required")
	private String name;
	
	@DateConversion(format = "", messageKey = "validation.dateofbirth.conversion")
	@AgeRange(minAge = 30, minAgeMessageKey = "validation.dateofbirth.minage", maxAge = 150, maxAgeMessageKey = "validation.dateofbirth.maxage")
	private Date dateOfBirth;
	
	@Required(messageKey = "validation.wikipediaentry.required")
	@StartsWith(startsWith = "https://en.wikipedia.org/", messageKey = "validation.wikipediaentry.notwikipedia")
	private String wikipediaEntry;
	
	@DateRangeListConversion(format = "", messageKey = "validation.termsofoffice.conversion")
	@NoDateRangeOverlap(messageKey = "validation.termsofoffice.overlap")
	private List<DateRange> termsOfOffice; // Non overlap check
	
	private Party party;
	
	@IntegerLocaleConversion(messageKey = "validation.maxseatswon.conversion")
	@IntegerInnerOuterRange(outerMin = 1, tooLowMessageKey = "validation.maxseatswon.toolow", 
	                        innerMin = 325, warningLowMessageKey = "validation.maxseatswon.warningtoolow",
	                        innerMax = 425, warningHighMessageKey = "validation.maxseatswon.warningtoohigh",
	                        outerMax = 707, tooHighMessageKey = "validation.maxseatswon.toohigh")
	private Integer maxSeatsWon;

	@MaxLength(maxLength = 50, messageKey = "validation.constituency.maxlength")
	private String constituency;
	
	@IntegerLocaleConversion(messageKey = "validation.bestconstituencymajority.conversion")
	@IntegerRange(min = 0, max = 150000, messageKey = "validation.bestconstituencymajority.range")
	private Integer bestConstituencyMajority;
	
	@ShortConversion(messageKey = "validation.bestConstituencyYear.conversion")
	@ShortRange(min = 1950, max = 2100, messageKey = "validation.bestConstituencyYear.range")
	private Short bestConstituencyYear;
	

	public PrimeMinisterForm() {
		// Default constructor required
	}
	
	public PrimeMinisterForm(PrimeMinisterDTO primeMinister) throws Exception {
		// Uses commons-beanutils
		PropertyUtils.copyProperties(this, primeMinister);
	}
	
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public Date getDateOfBirth() {
		return dateOfBirth;
	}
	public void setDateOfBirth(Date dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}

	public String getWikipediaEntry() {
		return wikipediaEntry;
	}
	public void setWikipediaEntry(String wikipediaEntry) {
		this.wikipediaEntry = wikipediaEntry;
	}
	
	public List<DateRange> getTermsOfOffice() {
		return termsOfOffice;
	}
	public void setTermsOfOffice(List<DateRange> termsOfOffice) {
		this.termsOfOffice = termsOfOffice;
	}

	public Party getParty() {
		return party;
	}
	public void setParty(Party party) {
		this.party = party;
	}

	public Integer getMaxSeatsWon() {
		return maxSeatsWon;
	}
	public void setMaxSeatsWon(Integer maxSeatsWon) {
		this.maxSeatsWon = maxSeatsWon;
	}

	
	public String getConstituency() {
		return constituency;
	}
	public void setConstituency(String constituency) {
		this.constituency = constituency;
	}

	public Integer getBestConstituencyMajority() {
		return bestConstituencyMajority;
	}
	public void setBestConstituencyMajority(Integer bestConstituencyMajority) {
		this.bestConstituencyMajority = bestConstituencyMajority;
	}

	public Short getBestConstituencyYear() {
		return bestConstituencyYear;
	}
	public void setBestConstituencyYear(Short bestConstituencyYear) {
		this.bestConstituencyYear = bestConstituencyYear;
	}

	
	@Override
	public String toString() {
		final int maxLen = 10;
		return "PrimeMinisterForm [" + (name != null ? "name=" + name + ", " : "")
				+ (dateOfBirth != null ? "dateOfBirth=" + dateOfBirth + ", " : "")
				+ (wikipediaEntry != null ? "wikipediaEntry=" + wikipediaEntry + ", " : "")
				+ (termsOfOffice != null
						? "termsOfOffice=" + termsOfOffice.subList(0, Math.min(termsOfOffice.size(), maxLen)) + ", "
						: "")
				+ (party != null ? "party=" + party + ", " : "")
				+ (maxSeatsWon != null ? "maxSeatsWon=" + maxSeatsWon + ", " : "")
				+ (constituency != null ? "constituency=" + constituency + ", " : "")
				+ (bestConstituencyMajority != null ? "bestConstituencyMajority=" + bestConstituencyMajority + ", "
						: "")
				+ (bestConstituencyYear != null ? "bestConstituencyYear=" + bestConstituencyYear : "") + "]";
	}

}