package name.matthewgreet.example11.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import name.matthewgreet.strutscommons.annotation.Required.MessageType;

/**
 * <P>Defines error message to display if an integer is not within an outer range and warning message if it's within 
 * outer but not inner range.</P>
 * 
 * <P>By default, messages for the outer range failure are added to the actionErrors list but this can be overridden by 
 * <CODE>messageType</CODE>:</P>
 * <DL>
 *   <DT>ERROR</DT><DD>Message added to Action level error messages.  Default.</DD>
 *   <DT>FIELD</DT><DD>Message added to field error messages.</DD>
 *   <DT>MESSAGE</DT><DD>Message added to Action level info messages.</DD>
 *   <DT>WARNING</DT><DD>Message added to Action level warning messages.</DD>
 * </DL>
 * <P>The message type for just inner range failure is warning.</P>
 * 
 * <P>Other parameters</P>
 * <DL>
 *   <DT>innerMax</DT><DD>Maximum value (inclusive) of inner range.  No default.</DD>
 *   <DT>innerMin</DT><DD>Minimum value (inclusive) of inner range.  No default.</DD>
 *   <DT>outerMax</DT><DD>Maximum value (inclusive) of outer range.  No default.</DD>
 *   <DT>outerMin</DT><DD>Minimum value (inclusive) of outer range.  No default.</DD>
 *   <DT>tooLowMessage</DT><DD>If not empty string, text message to display for value lower than outerMin.  Used 
 *                             if <CODE>messageKey</CODE> is not set or finds no message.</DD>
 *   <DT>tooLowMessageKey</DT><DD>If not empty string, message key to retrieve from Action's TextProvider for value 
 *                                lower than outerMin.  Uses <CODE>message</CODE> if no key provided or no message 
 *                                found.</DD>
 *   <DT>warningLowMessage</DT><DD>If not empty string, text message to display for value between outerMin and innerMin.  
 *                                 Used if <CODE>messageKey</CODE> is not set or finds no message.</DD>
 *   <DT>warningLowMessageKey</DT><DD>If not empty string, message key to retrieve from Action's TextProvider for value 
 *                                    between outerMin and innerMin.  Uses <CODE>message</CODE> if no key provided or no 
 *                                    message found.</DD>
 *   <DT>warningHighMessage</DT><DD>If not empty string, text message to display for value between innerMax and outerMax.  
 *                                  Used if <CODE>messageKey</CODE> is not set or finds no message.</DD>
 *   <DT>warningHighMessageKey</DT><DD>If not empty string, message key to retrieve from Action's TextProvider for value 
 *                                    between innerMax and outerMax.  Uses <CODE>message</CODE> if no key provided or no 
 *                                    message found.</DD>
 *   <DT>tooHighMessage</DT><DD>If not empty string, text message to display for value that exceeds outerMax.  Used if 
 *                              <CODE>messageKey</CODE> is not set or finds no message.</DD>
 *   <DT>tooHighMessageKey</DT><DD>If not empty string, message key to retrieve from Action's TextProvider for value 
 *                                 that exceeds outerMax.  Uses <CODE>message</CODE> if no key provided or no message 
 *                                 found.</DD>
 *   <DT>shortCircuit</DT><DD>If true and this validation fails, skips further validation.  Defaults to false.</DD>
 * </DL>
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface IntegerInnerOuterRange {
    public int innerMax(); 
    public int innerMin(); 
    public int outerMax(); 
    public int outerMin(); 
    public String tooLowMessage() default "";
    public String tooLowMessageKey() default "";
    public String warningLowMessage() default "";
    public String warningLowMessageKey() default "";
    public String warningHighMessage() default "";
    public String warningHighMessageKey() default "";
    public String tooHighMessage() default "";
    public String tooHighMessageKey() default "";
    public MessageType messageType() default MessageType.ERROR;
    public boolean shortCircuit() default false;
}
