package name.matthewgreet.example11.action;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionSupport;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Actions;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;

import com.opensymphony.xwork2.ActionContext;

import name.matthewgreet.example11.dto.PrimeMinisterDTO;
import name.matthewgreet.example11.util.PrimeMinisterCompositeCache;
import name.matthewgreet.example11.view.LocaleSelectBoxDisplay;
import name.matthewgreet.example11.view.PrimeMinisterDisplay;
import name.matthewgreet.strutscommons.action.AbstractViewActionSupport;
import name.matthewgreet.strutscommons.util.ListCache;
import name.matthewgreet.strutscommons.util.NA;

/**
 * Displays list of UK Prime Ministers.  
 */
@SuppressWarnings("deprecation")
@InterceptorRef("ViewStack")
@Results({
	@Result(name=ActionSupport.SUCCESS, location="/pages/PrimeMinisterList.jsp")
})
public class ViewPrimeMinisterListAction extends AbstractViewActionSupport {
	private static final long serialVersionUID = -7979376337555804889L;
	
    private Logger LOG = LogManager.getLogger(ViewPrimeMinisterListAction.class);
    
    
    private List<PrimeMinisterDisplay> listDisplay;
    
	private LocaleSelectBoxDisplay localeSelectBoxDisplay;
	

	
    @Actions({
    	@Action("/"),
    	@Action("/ViewPrimeMinisterList")
    })
    @Override
    public String execute() throws Exception {
    	ListCache<NA,Integer,PrimeMinisterDTO> listCache;
    	HttpSession session;
    	List<PrimeMinisterDTO> list;
    	
    	session = getBrowserTabSession();
    	
    	listCache = PrimeMinisterCompositeCache.getInstance(session).getMasterListCache();
    	list = listCache.getList();
	    
	    listDisplay = new ArrayList<>();
	    for (PrimeMinisterDTO primeMinister: list) {
	    	listDisplay.add(new PrimeMinisterDisplay(primeMinister));
	    }
	    
	    localeSelectBoxDisplay = new LocaleSelectBoxDisplay();
	    localeSelectBoxDisplay.setSelectedValue(ActionContext.getContext().getLocale().getLanguage() + "_" + ActionContext.getContext().getLocale().getCountry());
	    
		return SUCCESS;
    }

	@Override
	public Logger getLogger() {
		return LOG;
	}


	public List<PrimeMinisterDisplay> getListDisplay() {
		return listDisplay;
	}


	public LocaleSelectBoxDisplay getLocaleSelectBoxDisplay() {
		return localeSelectBoxDisplay;
	}

}
